#include "CGen2LockDialog.h"
#include <QMessageBox>
#include <QTimer>

#include <tag/QrfeGen2Tag>

CGen2LockDialog::CGen2LockDialog(QWidget *parent)
    : QDialog(parent)
{
	ui.setupUi(this);
	setInfoEdit(ui.infoEdit);

	connect(ui.okButton, 			SIGNAL(clicked()), 					this, SLOT(tryAccept()));
	connect(ui.cancelButton, 		SIGNAL(clicked()), 					this, SLOT(reject()));
	connect(ui.lockActionBox,		SIGNAL(currentIndexChanged(int)), 	this, SLOT(loadDescription()) );
	connect(ui.lockMemoryBox,		SIGNAL(currentIndexChanged(int)), 	this, SLOT(loadDescription()) );

	m_descriptions = QStringList()
		<< "Associated memory bank is writeable from either the open or secured states."
		<< "Associated memory bank is permanently writeable from either the open or secured states and may never be locked."
		<< "Associated memory bank is writeable from the secured state but not from the open state."
		<< "Associated memory bank is not writeable from any state."
		<< "Associated password location is readable and writeable from either the open or secured states."
		<< "Associated password location is permanently readable and writeable from either the open or secured states and may never be locked."
		<< "Associated password location is readable and writeable from the secured state but not from the open state."
		<< "Associated password location is not readable or writeable from any state."
		;
}

CGen2LockDialog::~CGen2LockDialog()
{

}


int CGen2LockDialog::exec(QrfeGen2Tag* tag)
{
	m_tag = tag;

	clearInfo();

	ui.tagIdEdit->setText(m_tag->tagId());
	ui.passwordLineEdit->setText("00-00-00-00");

	ui.lockActionBox->setCurrentIndex(0);
	ui.lockMemoryBox->setCurrentIndex(2);

	loadDescription();

	return QDialog::exec();
}

void CGen2LockDialog::tryAccept()
{
	clearInfo();

	if(!ui.passwordLineEdit->hasAcceptableInput())
	{
		QMessageBox::critical(this, "Error", "The password is not a valid!");
		return;
	}

	bool ok = false;
	QByteArray passw = QrfeGlobal::stringToBytes(ui.passwordLineEdit->text(), &ok);
	if(!ok)
	{
		QMessageBox::critical(this, "Error", "The password is not a valid!");
		return;
	}

	QrfeGen2Tag::LOCK_MODE mode = (QrfeGen2Tag::LOCK_MODE)ui.lockActionBox->currentIndex();
	QrfeGen2Tag::LOCK_MEMORY_SPACE mem = (QrfeGen2Tag::LOCK_MEMORY_SPACE)ui.lockMemoryBox->currentIndex();

	QrfeGlobal::TMIResult res = QrfeGlobal::TMI_ERROR;

	res = m_tag->lockTag(mode, mem, passw);

	if(res == QrfeGlobal::TMI_OK){
		QString action;
		if(ui.lockActionBox->currentIndex() == 0)
			action = "Unlocked";
		else
			action = "Locked";
		infoSetOK("-- " + action + " tag " + ui.tagIdEdit->text() + " - OK -- ");
		QMessageBox::information(this, action, action + " tag " + ui.tagIdEdit->text());
		QDialog::accept();
	}
	else
		handleError(res, "Could not lock tag");
}


void CGen2LockDialog::loadDescription()
{
	uchar action = ui.lockActionBox->currentIndex();
	uchar memspace = ui.lockMemoryBox->currentIndex();

	if(action == 1) action = 2;
	else if (action == 2) action = 1;

	uchar index = action;

	if(memspace <= 1)
		index += 4;

	ui.descriptionLabel->setText(m_descriptions.at(index));

	QTimer::singleShot(0, this, SLOT(shrink()));
}


void CGen2LockDialog::shrink()
{
	this->resize(380,0);
	this->setParent(this->parentWidget());
}
